<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use App\Models\Player;
use App\Models\ProductDailyWinTime;
use App\Models\ProductInPromo;
use App\Models\SendSmsCmr;
use App\Models\WinnerGeneralSelected;
use App\Models\WinnerSelected;
use Carbon\Carbon;
use GuzzleHttp\Client;
use GuzzleHttp\RequestOptions;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class PrizingTaskController extends Controller
{
    public function checkIfWinner() {
       // \Artisan::call();

        $currentTime = Carbon::now();
        $currentTimeStamps = $currentTime->timestamp;

        $productDailiWinTime = ProductDailyWinTime::where('winner_time', '<', $currentTimeStamps)
            ->where('isWon', false)
            ->orderBy('id', 'asc')
            ->first()
            ;

        if(!($productDailiWinTime instanceof ProductDailyWinTime)) {
            return response()->json([
                'iswinner' => 0,
                'pos' => 0
            ]);
        }

        $product = ProductInPromo::find($productDailiWinTime->product_id);

        $randWinnerFind = rand(0, 10);

        if($randWinnerFind % 3 != 0)  {
            return response()->json([
                'iswinner' => 0,
                'pos' => 1
            ]);
        }



        return response()->json([
            'iswinner' => 1,
            'posIndex' => $product->indexPos,
            'product_name' => $product->product_name,
            'winningid' => $productDailiWinTime->id,
            'product_id' => $product->id
        ]);
    }


    public function saveWinner(Request $request) {

        $lastPLayer = Player::orderBy('id', 'desc')
            ->first();

        if(!($lastPLayer instanceof Player)) {
            return response()->json([
                'isDone' => 0
            ]);
        }

        $currentTime = Carbon::now();
        $currentTimeStamps = $currentTime->timestamp;

        $prouctWinning = ProductDailyWinTime::where('winner_time', '<', $currentTimeStamps)
            ->where('isWon', false)
            ->orderBy('id', 'asc')
            ->first()
        ;

        if(!($prouctWinning instanceof ProductDailyWinTime)) {
            return response()->json([
                'isDone' => 0
            ]);
        }

        // $productInPromo = ProductInPromo::find($prouctWinning->product_id);
        $prouctWinning->isWon = true;
        $prouctWinning->player_id = $lastPLayer->id;
        $prouctWinning->save();

        $message = "Felicitation Mr/Mme ". $lastPLayer->prenom . " Vous venez de gagner un lot. #Ref: ".$prouctWinning->id;
        $this->SendSms($lastPLayer->telephone, $message);

        return response()->json([
            'isDone' => 1
        ]);
    }


    private function SendSms($cellphone,  $message) {
        Log::info($cellphone ." should received the message :".$message);

        $smsSendCmr = new SendSmsCmr;
        $smsSendCmr->phonenumber = $cellphone;
        $smsSendCmr->message = $message;
        $smsSendCmr->save();
        return true;
    }

    public function sendTombolaNum() {
        $lastPLayer = Player::orderBy('id', 'desc')
            ->first();

        if(!($lastPLayer instanceof Player)) {
            return response()->json([
                'isDone' => 0
            ]);
        }

        $message = "Mr/Mme ". $lastPLayer->prenom . " Votre numero de tombola est ". $lastPLayer->tombola_num .". Bien vouloir le conserver et le presenter si vous etes l'heureux gagnant";
        $this->SendSms($lastPLayer->telephone, $message);

        return response()->json([
            "isOK"=> 1
        ]);
    }


    public function generateRandon75() {
        $allPlayers = Player::where('montant_depense', 'like', '25000')
            ->get();

        $allCodes = array();

        foreach ($allPlayers as $aPlayer) {
            $allCodes[] = $aPlayer->tombola_num;
        }

        shuffle($allCodes);

        $possibleWinners = array();
        $j = 0;
        foreach ($allCodes as $aCode) {
            $count = Player::where('tombola_num', '=', $aCode)
                ->count();

            if($count != 1) {
                continue;
            }

            $possibleWinners[] = $aCode;
            $j += 1;
            if($j == 75) {
                break;
            }
        }

        return response()->json($possibleWinners);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     * @throws \GuzzleHttp\Exception\GuzzleException
     */
    public function saveBigPossibleWinner(Request $request) {

        try {
            $winnerCode = $request->input('code');
        } catch (\Exception $e) {
            return response()->json([
                "isOK" => "0"
            ]);
        }

        $player = Player::where('tombola_num', '=', $winnerCode)
            ->first();

        $winnerSelected = new WinnerSelected();

        $winnerSelected->tombola_num = $player->tombola_num;
        $winnerSelected->telephone = $player->telephone;
        $winnerSelected->player_name = $player->prenom . " ".$player->nom;
        $winnerSelected->save();

        //now lets save to distant DB
        $client = new Client(['verify' => false]);

        $dataToSend = array(
            'store' => "Dalip",
            "tombola_num" => $winnerSelected->tombola_num,
            "telephone" => $winnerSelected->telephone,
            "player_name" => $winnerSelected->player_name
        );
        try {
            //Live one
            $client->post('http://dev.sdkgames.com/carrefour/api/storegeneralwinner', [
                RequestOptions::JSON => $dataToSend
            ]);

           /*
           //Yaounde only
            $client->post('http://localhost/carrefour/api/storegeneralwinner', [
                RequestOptions::JSON => $dataToSend
            ]);
           */


        } catch (\Exception $e) {
            return response()->json([
                "isOK" => "-1"
            ]);
        }


        return response()->json([
            "isOK" => "1"
        ]);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function storegeneralwinner(Request $request) {

        $data = $request->json()->all();
        Log::info( " je passe ici dans storegeneralwinner".json_encode($data));

        try {
            $store = $data['store'];
            $tombala_num = $data['tombola_num'];
            $telephone = $data['telephone'];
            $player_name = $data['player_name'];

        } catch (\Exception $e) {
            Log::info( " Could not proceed posted data".json_encode($data));
        }

        $generalSelectWinner = new WinnerGeneralSelected();
        $generalSelectWinner->player_name = $player_name;
        $generalSelectWinner->tombola_num = $tombala_num;
        $generalSelectWinner->telephone = $telephone;
        $generalSelectWinner->store_name = $store;
        $generalSelectWinner->save();

        return response()->json();
    }


    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function randomBigPossibleWinner() {
        $listUsers = Player::where('montant_depense', '=', '25000')
            ->get();
        $listCode = array();

        foreach ($listUsers as $user) {
            $listCode[] =  $user->tombola_num;
        }
/*
        if(count($listCode) < 75) {
            while(count($listCode) < 75 ) {
                foreach ($listUsers as $user) {
                    $listCode[] =  $user->tombola_num;
                }
            }
        }
*/
        shuffle($listCode);

        if (count($listCode) > 55) {
            $listCode = array_slice($listCode, 0, 55);
        }


        return response()->json($listCode);
    }

    public function randomBigPossibleWinner2() {
        $listUsers = WinnerGeneralSelected::all();
        $listCode = array();

        foreach ($listUsers as $user) {
            $listCode[] =  $user->tombola_num;
        }

        if(count($listCode) < 25) {
            while(count($listCode) < 25 ) {
                foreach ($listUsers as $user) {
                    $listCode[] =  $user->tombola_num;
                }
            }
        }
        shuffle($listCode);

        if (count($listCode) > 25) {
            $listCode = array_slice($listCode, 0, 25);
        }

        return response()->json($listCode);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function listPossibleWinner(Request $request) {

        try {
            $shop = $request->input('store');
        } catch (\Exception $e) {
            $shop = null;
        }

        if($shop) {
            $listPlayers = WinnerGeneralSelected::where('store_name', 'like', $shop)
                ->get();
        } else {
            $listPlayers = WinnerGeneralSelected::all();
        }

        $winnerCodes = array();

        foreach ($listPlayers as $player) {
            $infoPlayer = new \stdClass();
            $infoPlayer->store_name = $player->store_name;
            $infoPlayer->tombola_num = $player->tombola_num;

            $winnerCodes[] = $infoPlayer;
        }

        return response()->json($winnerCodes);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function saveageneralWinner(Request $request) {

        try {
            $code = $request->input('code');
            $prize = $request->input('prize');

        } catch (\Exception $e) {
            return response()->json([
                "isOK" => "0"
            ]);
        }

        $player = Player::where('tombola_num', 'like', $code)
            ->first();

        $generalPlayer = new WinnerGeneralSelected();
        $generalPlayer->player_name = $player->prenom . " ".$player->nom;
        $generalPlayer->tombola_num = $player->tombola_num;
        $generalPlayer->telephone = $player->telephone;
        $generalPlayer->store_name = "Local";
        $generalPlayer->is_winner = true;
        $generalPlayer->winning_prise = $prize;
        $generalPlayer->save();

        return response()->json($generalPlayer);
    }

    /**
     * @return \Illuminate\Http\JsonResponse
     */
    public function generalwiners() {
        $generalWinners = WinnerGeneralSelected::where('is_winner', '=', 1)
            ->orderBy('id', 'asc')
            ->get();
        $infoPlayer = new \stdClass();
        $infoPlayer->Items = $generalWinners;
        return response()->json($infoPlayer);
    }


    public function clearAllData() {
        WinnerGeneralSelected::truncate();
        WinnerSelected::truncate();
        return response()->json([
            'isOK' => 'OK'
        ]);
    }
}
